/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.table.cell;

import ivorius.ivtoolkit.gui.GuiControlListener;
import ivorius.ivtoolkit.gui.GuiSlider;
import ivorius.reccomplex.gui.table.Bounds;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.cell.TableCellPropertyDefault;
import ivorius.reccomplex.utils.scale.Scale;
import ivorius.reccomplex.utils.scale.Scales;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class TableCellSlider<T>
extends TableCellPropertyDefault<T>
implements GuiControlListener<GuiSlider> {
    protected GuiSlider slider = new GuiSlider(-1, 0, 0, 0, 0, "");
    protected T min;
    protected T max;
    protected Scale scale;

    public TableCellSlider(String id, T value, T min, T max) {
        super(id, value);
        this.slider.addListener((GuiControlListener)this);
        this.scale = Scales.none();
        this.setMin(min);
        this.setMax(max);
        this.setPropertyValue(value);
    }

    public T getMin() {
        return this.min;
    }

    public void setMin(T min) {
        this.min = min;
        this.slider.setMinValue(this.scale.out(this.serialize(min)));
    }

    public T getMax() {
        return this.max;
    }

    public void setMax(T max) {
        this.max = max;
        this.slider.setMaxValue(this.scale.out(this.serialize(max)));
    }

    public Scale getScale() {
        return this.scale;
    }

    public void setScale(Scale scale) {
        this.scale = scale;
        this.setMin(this.min);
        this.setMax(this.max);
        this.slider.setValue(scale.out(this.serialize(this.property)));
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.slider.field_146124_l = enabled;
    }

    protected abstract float serialize(T var1);

    @Nullable
    protected abstract T deserialize(float var1);

    protected abstract String displayString();

    @Override
    public void initGui(GuiTable screen) {
        super.initGui(screen);
        screen.addButton(this, 0, (GuiButton)this.slider);
    }

    @Override
    public void setHidden(boolean hidden) {
        super.setHidden(hidden);
        if (this.slider != null) {
            this.slider.field_146125_m = !hidden;
        }
    }

    public void valueChanged(GuiSlider gui) {
        this.property = this.deserialize(this.scale.in(gui.getValue()));
        gui.field_146126_j = this.displayString();
        this.alertListenersOfChange();
    }

    @Override
    public void setPropertyValue(T value) {
        super.setPropertyValue(value);
        if (this.slider != null) {
            this.slider.setValue(this.scale.out(this.serialize(this.property)));
            this.slider.field_146126_j = this.displayString();
        }
    }

    protected void updateSliderBounds(Bounds bounds) {
        Bounds.set((GuiButton)this.slider, Bounds.fromSize(bounds.getMinX(), bounds.getMinY() + (bounds.getHeight() - 20) / 2, bounds.getWidth(), 20));
    }

    @Override
    public void setBounds(Bounds bounds) {
        super.setBounds(bounds);
        if (this.slider != null) {
            this.updateSliderBounds(bounds);
        }
    }
}

